/*
  indent wget.c -bli0 -bfda -kr -psl -st
*/


#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <ctype.h>

#include "libfma.h"
#include "lf_wget.h"
#include "lf_internal.h"

#define GET_FORMAT "GET %s HTTP/1.0\r\n\r\n"
#define PUNCTUATION ":>"
#define CONTENT_TAG "Content-type"

/* define this to keep a record of every switch read */
#undef _FWS_USE_FILE_

static int
lf_wget_header(
  FILE *fp)
{
  char buffer[LF_STRING_LEN + 1];
  char *s;

  /* read up to 1st blank line */
  while ((s = lf_wget_gets ( buffer, LF_STRING_LEN, fp)) != NULL)
  {
    while (*s != '\0' && strchr("\r\n", *s) != NULL) {
      ++s;
    }
    if (*s == '\0') return 0;
  }

  return -1;
}

FILE *
lf_wget_open (
  char *host,
  char *request)
{
#if _DEBUG_SWITCH_
  lf_string_t path;
  FILE *fp;

  fp = NULL;

  /* open a connection to the host */
  sprintf(path, "/tmp/switch/%s%s", host,
          strcmp(request, "/") == 0 ? "/root" : request);
  fp = fopen(path, "r");
  if (fp == NULL) {
    LF_ERROR(("Cannot open %s", path));
  }
  return fp;

except:
  if (fp != NULL) {
    fclose(fp);
  }
  return NULL;

  lf_wget_header(fp);	/* to suppress compiler warning */

#else
  char *s;
  int fd;
  FILE *fp;
  int size;
  int rc;

  s = NULL;
  fd = -1;
  fp = NULL;

  /* open a connection to the host */
  fd = lf_connect_to_host (host, 80);
  if (fd == -1) {
    LF_ERROR(("Error connecting to web server on %s", host));
  }
  fp = fdopen(fd, "r+");
  if (fp == NULL) {
    LF_ERROR(("Error from fdopen()"));
  }

  /* build the text of the request */
  LF_CALLOC(s, char, strlen (GET_FORMAT) + strlen (request));
  size = sprintf (s, GET_FORMAT, request);

  /* write the request to the server */
  if (fwrite (s, 1, size, fp) != size) {
    LF_ERROR(("write failed"));
  }
  LF_FREE(s);

  rc = lf_wget_header(fp);
  if (rc != 0) {
    LF_ERROR(("Error reading HTML header"));
  }

#ifdef _FWS_USE_FILE_
  {
    time_t now;
    struct tm hms;
    lf_string_t fname;
    lf_string_t buf;
    FILE *hp;
    int rc;

    rc = access("/tmp/switchdata", R_OK|W_OK);
    if (rc != 0) {
      rc = mkdir("/tmp/switchdata", 0755);
      if  (rc == -1) {
	LF_ERROR(("Error creating /tmp/switchdata"));
      }
    }

    time(&now);
    (void) localtime_r(&now, &hms);

    sprintf(fname, "/tmp/switchdata/%s_%02d%02d%02d%02d%02d",
	host, hms.tm_mon+1, hms.tm_mday, hms.tm_hour, hms.tm_min, hms.tm_sec);

    hp = fp;
    fp = fopen(fname, "w");
    if (fp == NULL) {
      fp = hp;
      LF_ERROR(("Error opening swicth data file for write"));
    }

    while (fgets(buf, sizeof(buf), hp) != NULL) {
      fputs(buf, fp);
    }
    fclose(hp);
    fclose(fp);

    fp = fopen(fname, "r");
    if (fp == NULL) LF_ERROR(("Error opening swicth data file for read"));
  }
#endif
  return fp;

except:
  LF_FREE(s);
  if (fp != NULL) {
    fclose(fp);
  } else if (fd != -1) {
    close(fd);
  }
  return NULL;
#endif
}

char *
lf_wget_gets(
  char *s,
  int size,
  FILE *fp)
{
  int num_read = 0;
  int c = 0;
  int in_tag;

  /* not currently reading an HTML tag */
  in_tag = FALSE;

  while (num_read < size - 1) {
    c = getc(fp);
    if (c == '\r') {
      continue;
    }
    if (c == EOF || c == '\n') {
      break;
    }

    if (!in_tag && c == '<') {
      in_tag = TRUE;
    } else if (in_tag && c == '>') {
      in_tag = FALSE;
    } else {
      if (!in_tag) {
	if (strchr(PUNCTUATION, c) != NULL)
	{
	  if (num_read <= 0 || !isspace(s[num_read - 1])) {
	    s[num_read++] = ' ';
	  }
	} else {
	  s[num_read++] = c;
	}
      }
    }
  }

  s[num_read] = '\0';
  return c != EOF ? s : NULL;
}

void
lf_wget_close (FILE *fp)
{
  fclose (fp);
}

/*
 * Get the next line of input, parsed into words, skipping blank lines
 * and lines beginning with '#'
 * The buffer and max words must be at least LF_STRING_LEN
 */
char *
lf_wget_next_line(
  FILE *fp,
  char *buf,
  char **wp,
  int *wcp)
{
  while (lf_wget_gets(buf, LF_STRING_LEN, fp) != NULL) {

    /* skip blank lines and comments */
    if (buf[0] == '\0' || buf[0] == '\n' || buf[0] == '#') continue;

    /* break into words */
    line2words(buf, wp, "\n\t ", 0, wcp);
if (*wcp > LF_STRING_LEN) { fprintf(stderr, "wc = %d\n", *wcp); exit(1); }

    /* lines with only spaces are blank */
    if (*wcp == 0) continue;

    return buf;
  }

  return NULL;
}
